package backend

import (
	"code.justin.tv/vod/vinyl/models"

	"golang.org/x/net/context"
)

// GetVodsAggregationByID calls the appropriate readers to fetch vods by their IDs.
func (b *Backend) GetVodsAggregationByID(ctx context.Context, vodIDs []int64, filters *models.VodFilters) (*models.VodsAggregation, error) {
	dbVodsAggregation, err := b.Reader.GetVodsAggregationByID(ctx, vodIDs, filters)
	if err != nil {
		return nil, err
	}

	res, err := dbVodsAggregation.AsVinylVodsAggregation()
	if err != nil {
		return nil, err
	}

	return res, nil
}
