package backend

import (
	dbmodels "code.justin.tv/vod/vinyl/datastore/vinyldb/models"
	"code.justin.tv/vod/vinyl/models"

	"golang.org/x/net/context"
)

// GetVodsByID calls the appropriate readers to fetch vods by their IDs.
func (b *Backend) GetVodsByID(ctx context.Context, vodIDs []int64, appealsAndAMRs bool, notificationSettings bool, filters *models.VodFilters) ([]*models.Vod, error) {
	dbVods, err := b.Reader.GetVodsByID(ctx, vodIDs, filters)
	if err != nil {
		return nil, err
	}

	// Usher calls this endpoint through web/web's internal vod show endpoint and expects the showFormats field.
	res, err := convertVods(dbVods, dbmodels.SetShowFormats(true))
	if err != nil {
		return nil, err
	}

	if appealsAndAMRs {
		err = b.includeAppealsAndAMRs(ctx, res)
		if err != nil {
			return nil, err
		}
	}

	if notificationSettings {
		err = b.includeVodNotificationSettings(ctx, res)
		if err != nil {
			return nil, err
		}
	}

	return res, nil
}
