package backend

import (
	"time"

	"golang.org/x/net/context"

	"code.justin.tv/vod/vinyl/models"
)

// GetVodsByStatus takes in params and passes in the params to the readers of the backend
func (b *Backend) GetVodsByStatus(ctx context.Context, status string, broadcastType []string, startTime, endTime time.Time) ([]*models.Vod, error) {
	empty := []*models.Vod{}

	dbVods, err := b.Reader.GetVodsByStatus(ctx, status, broadcastType, startTime, endTime)
	if err != nil {
		return empty, err
	}

	vods, err := convertVods(dbVods)
	if err != nil {
		return empty, err
	}

	return vods, nil
}
