package backend

import (
	"code.justin.tv/vod/vinyl/models"
	"golang.org/x/net/context"
)

// GetVodsByUser calls the appropriate writers to fetch VOD information for a user.
func (b *Backend) GetVodsByUser(ctx context.Context, userID int, broadcastType, language, status []string, appealsAndAMRs bool, notificationSettings bool, filters *models.VodFilters, sort string, limit, offset int) ([]*models.Vod, error) {
	empty := []*models.Vod{}

	status = includeUnderReview(status)

	dbVods, err := b.Reader.GetVodsByUser(ctx, userID, broadcastType, language, status, filters, sort, limit, offset)
	if err != nil {
		return empty, err
	}

	vods, err := convertVods(dbVods)
	if err != nil {
		return empty, err
	}

	if appealsAndAMRs {
		err = b.includeAppealsAndAMRs(ctx, vods)
		if err != nil {
			return nil, err
		}
	}

	if notificationSettings {
		err = b.includeVodNotificationSettings(ctx, vods)
		if err != nil {
			return nil, err
		}
	}

	return vods, nil
}
