package mocks

import "github.com/stretchr/testify/mock"

import "time"
import dbmodels "code.justin.tv/vod/vinyl/datastore/vinyldb/models"
import "code.justin.tv/vod/vinyl/models"
import "golang.org/x/net/context"

// NamedReader is an autogenerated mock type for the NamedReader type
type NamedReader struct {
	mock.Mock
}

// FollowedVods provides a mock function with given fields: _a0, _a1, _a2, _a3, _a4, _a5, _a6, _a7
func (_m *NamedReader) FollowedVods(_a0 context.Context, _a1 []int, _a2 []string, _a3 []string, _a4 []string, _a5 string, _a6 int, _a7 int) ([]*dbmodels.Vod, error) {
	ret := _m.Called(_a0, _a1, _a2, _a3, _a4, _a5, _a6, _a7)

	var r0 []*dbmodels.Vod
	if rf, ok := ret.Get(0).(func(context.Context, []int, []string, []string, []string, string, int, int) []*dbmodels.Vod); ok {
		r0 = rf(_a0, _a1, _a2, _a3, _a4, _a5, _a6, _a7)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*dbmodels.Vod)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, []int, []string, []string, []string, string, int, int) error); ok {
		r1 = rf(_a0, _a1, _a2, _a3, _a4, _a5, _a6, _a7)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetAMRs provides a mock function with given fields: _a0, _a1
func (_m *NamedReader) GetAMRs(_a0 context.Context, _a1 int) ([]*dbmodels.AMR, error) {
	ret := _m.Called(_a0, _a1)

	var r0 []*dbmodels.AMR
	if rf, ok := ret.Get(0).(func(context.Context, int) []*dbmodels.AMR); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*dbmodels.AMR)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, int) error); ok {
		r1 = rf(_a0, _a1)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetAMRsByVodIDs provides a mock function with given fields: _a0, _a1
func (_m *NamedReader) GetAMRsByVodIDs(_a0 context.Context, _a1 []int64) ([]*dbmodels.AMR, error) {
	ret := _m.Called(_a0, _a1)

	var r0 []*dbmodels.AMR
	if rf, ok := ret.Get(0).(func(context.Context, []int64) []*dbmodels.AMR); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*dbmodels.AMR)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, []int64) error); ok {
		r1 = rf(_a0, _a1)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetIntervalVodIDsToDelete provides a mock function with given fields: _a0, _a1, _a2
func (_m *NamedReader) GetIntervalVodIDsToDelete(_a0 context.Context, _a1 time.Time, _a2 time.Time) ([]int64, error) {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 []int64
	if rf, ok := ret.Get(0).(func(context.Context, time.Time, time.Time) []int64); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]int64)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, time.Time, time.Time) error); ok {
		r1 = rf(_a0, _a1, _a2)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetRelatedVods provides a mock function with given fields: _a0, _a1, _a2
func (_m *NamedReader) GetRelatedVods(_a0 context.Context, _a1 int, _a2 int) ([]*dbmodels.Vod, error) {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 []*dbmodels.Vod
	if rf, ok := ret.Get(0).(func(context.Context, int, int) []*dbmodels.Vod); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*dbmodels.Vod)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, int, int) error); ok {
		r1 = rf(_a0, _a1, _a2)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetScheduledVods provides a mock function with given fields: _a0
func (_m *NamedReader) GetScheduledVods(_a0 context.Context) ([]*dbmodels.Vod, error) {
	ret := _m.Called(_a0)

	var r0 []*dbmodels.Vod
	if rf, ok := ret.Get(0).(func(context.Context) []*dbmodels.Vod); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*dbmodels.Vod)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetStaleUnmoderatedVods provides a mock function with given fields: _a0
func (_m *NamedReader) GetStaleUnmoderatedVods(_a0 context.Context) ([]*dbmodels.Vod, error) {
	ret := _m.Called(_a0)

	var r0 []*dbmodels.Vod
	if rf, ok := ret.Get(0).(func(context.Context) []*dbmodels.Vod); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*dbmodels.Vod)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetTopVods provides a mock function with given fields: _a0, _a1, _a2, _a3, _a4, _a5, _a6, _a7
func (_m *NamedReader) GetTopVods(_a0 context.Context, _a1 []string, _a2 []string, _a3 string, _a4 string, _a5 string, _a6 int, _a7 int) ([]*dbmodels.Vod, error) {
	ret := _m.Called(_a0, _a1, _a2, _a3, _a4, _a5, _a6, _a7)

	var r0 []*dbmodels.Vod
	if rf, ok := ret.Get(0).(func(context.Context, []string, []string, string, string, string, int, int) []*dbmodels.Vod); ok {
		r0 = rf(_a0, _a1, _a2, _a3, _a4, _a5, _a6, _a7)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*dbmodels.Vod)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, []string, []string, string, string, string, int, int) error); ok {
		r1 = rf(_a0, _a1, _a2, _a3, _a4, _a5, _a6, _a7)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetTrackAppealsByVodAppealIDs provides a mock function with given fields: _a0, _a1
func (_m *NamedReader) GetTrackAppealsByVodAppealIDs(_a0 context.Context, _a1 []int64) ([]*dbmodels.TrackAppeal, error) {
	ret := _m.Called(_a0, _a1)

	var r0 []*dbmodels.TrackAppeal
	if rf, ok := ret.Get(0).(func(context.Context, []int64) []*dbmodels.TrackAppeal); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*dbmodels.TrackAppeal)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, []int64) error); ok {
		r1 = rf(_a0, _a1)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetTranscodingVodsCountByUser provides a mock function with given fields: _a0, _a1
func (_m *NamedReader) GetTranscodingVodsCountByUser(_a0 context.Context, _a1 int64) (int64, error) {
	ret := _m.Called(_a0, _a1)

	var r0 int64
	if rf, ok := ret.Get(0).(func(context.Context, int64) int64); ok {
		r0 = rf(_a0, _a1)
	} else {
		r0 = ret.Get(0).(int64)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, int64) error); ok {
		r1 = rf(_a0, _a1)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetUserVODProperties provides a mock function with given fields: _a0, _a1
func (_m *NamedReader) GetUserVODProperties(_a0 context.Context, _a1 int64) (*dbmodels.UserVodProperties, error) {
	ret := _m.Called(_a0, _a1)

	var r0 *dbmodels.UserVodProperties
	if rf, ok := ret.Get(0).(func(context.Context, int64) *dbmodels.UserVodProperties); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dbmodels.UserVodProperties)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, int64) error); ok {
		r1 = rf(_a0, _a1)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetUserVideoPrivacyProperties provides a mock function with given fields: _a0, _a1
func (_m *NamedReader) GetUserVideoPrivacyProperties(_a0 context.Context, _a1 int64) (*models.UserVideoPrivacyProperties, error) {
	ret := _m.Called(_a0, _a1)

	var r0 *models.UserVideoPrivacyProperties
	if rf, ok := ret.Get(0).(func(context.Context, int64) *models.UserVideoPrivacyProperties); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*models.UserVideoPrivacyProperties)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, int64) error); ok {
		r1 = rf(_a0, _a1)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetUserVideoPrivacyPropertiesBatch provides a mock function with given fields: _a0, _a1
func (_m *NamedReader) GetUserVideoPrivacyPropertiesBatch(_a0 context.Context, _a1 []int64) (map[int64]models.UserVideoPrivacyProperties, error) {
	ret := _m.Called(_a0, _a1)

	var r0 map[int64]models.UserVideoPrivacyProperties
	if rf, ok := ret.Get(0).(func(context.Context, []int64) map[int64]models.UserVideoPrivacyProperties); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[int64]models.UserVideoPrivacyProperties)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, []int64) error); ok {
		r1 = rf(_a0, _a1)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetVodAppeals provides a mock function with given fields: _a0, _a1, _a2, _a3, _a4, _a5, _a6
func (_m *NamedReader) GetVodAppeals(_a0 context.Context, _a1 models.NullBool, _a2 models.NullBool, _a3 string, _a4 models.NullInt64, _a5 int, _a6 int) ([]*dbmodels.VodAppeal, error) {
	ret := _m.Called(_a0, _a1, _a2, _a3, _a4, _a5, _a6)

	var r0 []*dbmodels.VodAppeal
	if rf, ok := ret.Get(0).(func(context.Context, models.NullBool, models.NullBool, string, models.NullInt64, int, int) []*dbmodels.VodAppeal); ok {
		r0 = rf(_a0, _a1, _a2, _a3, _a4, _a5, _a6)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*dbmodels.VodAppeal)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, models.NullBool, models.NullBool, string, models.NullInt64, int, int) error); ok {
		r1 = rf(_a0, _a1, _a2, _a3, _a4, _a5, _a6)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetVodAppealsByVodIDs provides a mock function with given fields: _a0, _a1
func (_m *NamedReader) GetVodAppealsByVodIDs(_a0 context.Context, _a1 []int64) ([]*dbmodels.VodAppeal, error) {
	ret := _m.Called(_a0, _a1)

	var r0 []*dbmodels.VodAppeal
	if rf, ok := ret.Get(0).(func(context.Context, []int64) []*dbmodels.VodAppeal); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*dbmodels.VodAppeal)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, []int64) error); ok {
		r1 = rf(_a0, _a1)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetVodAppealsCount provides a mock function with given fields: _a0, _a1, _a2, _a3, _a4
func (_m *NamedReader) GetVodAppealsCount(_a0 context.Context, _a1 models.NullBool, _a2 models.NullBool, _a3 string, _a4 models.NullInt64) (int64, error) {
	ret := _m.Called(_a0, _a1, _a2, _a3, _a4)

	var r0 int64
	if rf, ok := ret.Get(0).(func(context.Context, models.NullBool, models.NullBool, string, models.NullInt64) int64); ok {
		r0 = rf(_a0, _a1, _a2, _a3, _a4)
	} else {
		r0 = ret.Get(0).(int64)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, models.NullBool, models.NullBool, string, models.NullInt64) error); ok {
		r1 = rf(_a0, _a1, _a2, _a3, _a4)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetVodIDsByUser provides a mock function with given fields: _a0, _a1
func (_m *NamedReader) GetVodIDsByUser(_a0 context.Context, _a1 int64) ([]int64, error) {
	ret := _m.Called(_a0, _a1)

	var r0 []int64
	if rf, ok := ret.Get(0).(func(context.Context, int64) []int64); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]int64)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, int64) error); ok {
		r1 = rf(_a0, _a1)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetVodNotificationSettingsByVodIDs provides a mock function with given fields: _a0, _a1
func (_m *NamedReader) GetVodNotificationSettingsByVodIDs(_a0 context.Context, _a1 []int64) ([]*dbmodels.VodNotificationSettings, error) {
	ret := _m.Called(_a0, _a1)

	var r0 []*dbmodels.VodNotificationSettings
	if rf, ok := ret.Get(0).(func(context.Context, []int64) []*dbmodels.VodNotificationSettings); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*dbmodels.VodNotificationSettings)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, []int64) error); ok {
		r1 = rf(_a0, _a1)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetVodThumbnails provides a mock function with given fields: _a0, _a1
func (_m *NamedReader) GetVodThumbnails(_a0 context.Context, _a1 int64) (models.Thumbnails, error) {
	ret := _m.Called(_a0, _a1)

	var r0 models.Thumbnails
	if rf, ok := ret.Get(0).(func(context.Context, int64) models.Thumbnails); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(models.Thumbnails)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, int64) error); ok {
		r1 = rf(_a0, _a1)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetVodsAggregationByID provides a mock function with given fields: _a0, _a1, _a2
func (_m *NamedReader) GetVodsAggregationByID(_a0 context.Context, _a1 []int64, _a2 *models.VodFilters) (*dbmodels.VodsAggregation, error) {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 *dbmodels.VodsAggregation
	if rf, ok := ret.Get(0).(func(context.Context, []int64, *models.VodFilters) *dbmodels.VodsAggregation); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dbmodels.VodsAggregation)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, []int64, *models.VodFilters) error); ok {
		r1 = rf(_a0, _a1, _a2)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetVodsByID provides a mock function with given fields: _a0, _a1, _a2
func (_m *NamedReader) GetVodsByID(_a0 context.Context, _a1 []int64, _a2 *models.VodFilters) ([]*dbmodels.Vod, error) {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 []*dbmodels.Vod
	if rf, ok := ret.Get(0).(func(context.Context, []int64, *models.VodFilters) []*dbmodels.Vod); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*dbmodels.Vod)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, []int64, *models.VodFilters) error); ok {
		r1 = rf(_a0, _a1, _a2)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetVodsByStatus provides a mock function with given fields: _a0, _a1, _a2, _a3, _a4
func (_m *NamedReader) GetVodsByStatus(_a0 context.Context, _a1 string, _a2 []string, _a3 time.Time, _a4 time.Time) ([]*dbmodels.Vod, error) {
	ret := _m.Called(_a0, _a1, _a2, _a3, _a4)

	var r0 []*dbmodels.Vod
	if rf, ok := ret.Get(0).(func(context.Context, string, []string, time.Time, time.Time) []*dbmodels.Vod); ok {
		r0 = rf(_a0, _a1, _a2, _a3, _a4)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*dbmodels.Vod)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, []string, time.Time, time.Time) error); ok {
		r1 = rf(_a0, _a1, _a2, _a3, _a4)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetVodsByUser provides a mock function with given fields: _a0, _a1, _a2, _a3, _a4, _a5, _a6, _a7, _a8
func (_m *NamedReader) GetVodsByUser(_a0 context.Context, _a1 int, _a2 []string, _a3 []string, _a4 []string, _a5 *models.VodFilters, _a6 string, _a7 int, _a8 int) ([]*dbmodels.Vod, error) {
	ret := _m.Called(_a0, _a1, _a2, _a3, _a4, _a5, _a6, _a7, _a8)

	var r0 []*dbmodels.Vod
	if rf, ok := ret.Get(0).(func(context.Context, int, []string, []string, []string, *models.VodFilters, string, int, int) []*dbmodels.Vod); ok {
		r0 = rf(_a0, _a1, _a2, _a3, _a4, _a5, _a6, _a7, _a8)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*dbmodels.Vod)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, int, []string, []string, []string, *models.VodFilters, string, int, int) error); ok {
		r1 = rf(_a0, _a1, _a2, _a3, _a4, _a5, _a6, _a7, _a8)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetVodsCountByUser provides a mock function with given fields: _a0, _a1, _a2, _a3, _a4, _a5
func (_m *NamedReader) GetVodsCountByUser(_a0 context.Context, _a1 int, _a2 []string, _a3 []string, _a4 []string, _a5 *models.VodFilters) (int64, error) {
	ret := _m.Called(_a0, _a1, _a2, _a3, _a4, _a5)

	var r0 int64
	if rf, ok := ret.Get(0).(func(context.Context, int, []string, []string, []string, *models.VodFilters) int64); ok {
		r0 = rf(_a0, _a1, _a2, _a3, _a4, _a5)
	} else {
		r0 = ret.Get(0).(int64)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, int, []string, []string, []string, *models.VodFilters) error); ok {
		r1 = rf(_a0, _a1, _a2, _a3, _a4, _a5)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Health provides a mock function with given fields: _a0
func (_m *NamedReader) Health(_a0 context.Context) error {
	ret := _m.Called(_a0)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context) error); ok {
		r0 = rf(_a0)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Name provides a mock function with given fields:
func (_m *NamedReader) Name() string {
	ret := _m.Called()

	var r0 string
	if rf, ok := ret.Get(0).(func() string); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(string)
	}

	return r0
}

// OwnerForRechat provides a mock function with given fields: ctx, vodID
func (_m *NamedReader) OwnerForRechat(ctx context.Context, vodID int64) (*dbmodels.VodOwner, error) {
	ret := _m.Called(ctx, vodID)

	var r0 *dbmodels.VodOwner
	if rf, ok := ret.Get(0).(func(context.Context, int64) *dbmodels.VodOwner); ok {
		r0 = rf(ctx, vodID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dbmodels.VodOwner)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, int64) error); ok {
		r1 = rf(ctx, vodID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Utilization provides a mock function with given fields: _a0
func (_m *NamedReader) Utilization(_a0 context.Context) float32 {
	ret := _m.Called(_a0)

	var r0 float32
	if rf, ok := ret.Get(0).(func(context.Context) float32); ok {
		r0 = rf(_a0)
	} else {
		r0 = ret.Get(0).(float32)
	}

	return r0
}
