package mocks

import "github.com/stretchr/testify/mock"

import "code.justin.tv/vod/vinyl/models"
import dbmodels "code.justin.tv/vod/vinyl/datastore/vinyldb/models"
import "golang.org/x/net/context"

// NamedWriter is an autogenerated mock type for the NamedWriter type
type NamedWriter struct {
	mock.Mock
}

// CreateAMRs provides a mock function with given fields: _a0, _a1, _a2, _a3
func (_m *NamedWriter) CreateAMRs(_a0 context.Context, _a1 int64, _a2 []*models.AMR, _a3 bool) ([]int64, error) {
	ret := _m.Called(_a0, _a1, _a2, _a3)

	var r0 []int64
	if rf, ok := ret.Get(0).(func(context.Context, int64, []*models.AMR, bool) []int64); ok {
		r0 = rf(_a0, _a1, _a2, _a3)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]int64)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, int64, []*models.AMR, bool) error); ok {
		r1 = rf(_a0, _a1, _a2, _a3)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CreateHighlight provides a mock function with given fields: _a0, _a1, _a2
func (_m *NamedWriter) CreateHighlight(_a0 context.Context, _a1 *models.HighlightInput, _a2 bool) (*dbmodels.Vod, error) {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 *dbmodels.Vod
	if rf, ok := ret.Get(0).(func(context.Context, *models.HighlightInput, bool) *dbmodels.Vod); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dbmodels.Vod)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, *models.HighlightInput, bool) error); ok {
		r1 = rf(_a0, _a1, _a2)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CreatePastBroadcast provides a mock function with given fields: _a0, _a1, _a2
func (_m *NamedWriter) CreatePastBroadcast(_a0 context.Context, _a1 *models.Vod, _a2 bool) (*dbmodels.Vod, error) {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 *dbmodels.Vod
	if rf, ok := ret.Get(0).(func(context.Context, *models.Vod, bool) *dbmodels.Vod); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dbmodels.Vod)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, *models.Vod, bool) error); ok {
		r1 = rf(_a0, _a1, _a2)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CreateThumbnails provides a mock function with given fields: _a0, _a1, _a2
func (_m *NamedWriter) CreateThumbnails(_a0 context.Context, _a1 int64, _a2 models.Thumbnails) (models.Thumbnails, error) {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 models.Thumbnails
	if rf, ok := ret.Get(0).(func(context.Context, int64, models.Thumbnails) models.Thumbnails); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(models.Thumbnails)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, int64, models.Thumbnails) error); ok {
		r1 = rf(_a0, _a1, _a2)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CreateTrackAppeals provides a mock function with given fields: _a0, _a1, _a2, _a3
func (_m *NamedWriter) CreateTrackAppeals(_a0 context.Context, _a1 []*models.TrackAppeal, _a2 int64, _a3 bool) ([]int64, error) {
	ret := _m.Called(_a0, _a1, _a2, _a3)

	var r0 []int64
	if rf, ok := ret.Get(0).(func(context.Context, []*models.TrackAppeal, int64, bool) []int64); ok {
		r0 = rf(_a0, _a1, _a2, _a3)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]int64)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, []*models.TrackAppeal, int64, bool) error); ok {
		r1 = rf(_a0, _a1, _a2, _a3)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CreateVodAppeal provides a mock function with given fields: _a0, _a1, _a2
func (_m *NamedWriter) CreateVodAppeal(_a0 context.Context, _a1 *models.VodAppeal, _a2 bool) (int64, error) {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 int64
	if rf, ok := ret.Get(0).(func(context.Context, *models.VodAppeal, bool) int64); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		r0 = ret.Get(0).(int64)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, *models.VodAppeal, bool) error); ok {
		r1 = rf(_a0, _a1, _a2)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DeleteThumbnail provides a mock function with given fields: _a0, _a1, _a2
func (_m *NamedWriter) DeleteThumbnail(_a0 context.Context, _a1 int64, _a2 string) error {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, int64, string) error); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DeleteThumbnails provides a mock function with given fields: _a0, _a1
func (_m *NamedWriter) DeleteThumbnails(_a0 context.Context, _a1 int64) error {
	ret := _m.Called(_a0, _a1)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, int64) error); ok {
		r0 = rf(_a0, _a1)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DeleteVods provides a mock function with given fields: _a0, _a1
func (_m *NamedWriter) DeleteVods(_a0 context.Context, _a1 []int64) error {
	ret := _m.Called(_a0, _a1)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, []int64) error); ok {
		r0 = rf(_a0, _a1)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Health provides a mock function with given fields: _a0
func (_m *NamedWriter) Health(_a0 context.Context) error {
	ret := _m.Called(_a0)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context) error); ok {
		r0 = rf(_a0)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Name provides a mock function with given fields:
func (_m *NamedWriter) Name() string {
	ret := _m.Called()

	var r0 string
	if rf, ok := ret.Get(0).(func() string); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(string)
	}

	return r0
}

// ResolveTrackAppeal provides a mock function with given fields: _a0, _a1, _a2
func (_m *NamedWriter) ResolveTrackAppeal(_a0 context.Context, _a1 int64, _a2 bool) (int64, int64, error) {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 int64
	if rf, ok := ret.Get(0).(func(context.Context, int64, bool) int64); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		r0 = ret.Get(0).(int64)
	}

	var r1 int64
	if rf, ok := ret.Get(1).(func(context.Context, int64, bool) int64); ok {
		r1 = rf(_a0, _a1, _a2)
	} else {
		r1 = ret.Get(1).(int64)
	}

	var r2 error
	if rf, ok := ret.Get(2).(func(context.Context, int64, bool) error); ok {
		r2 = rf(_a0, _a1, _a2)
	} else {
		r2 = ret.Error(2)
	}

	return r0, r1, r2
}

// ResolveVodAppeal provides a mock function with given fields: _a0, _a1
func (_m *NamedWriter) ResolveVodAppeal(_a0 context.Context, _a1 int64) (int64, error) {
	ret := _m.Called(_a0, _a1)

	var r0 int64
	if rf, ok := ret.Get(0).(func(context.Context, int64) int64); ok {
		r0 = rf(_a0, _a1)
	} else {
		r0 = ret.Get(0).(int64)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, int64) error); ok {
		r1 = rf(_a0, _a1)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SetUserVODProperties provides a mock function with given fields: _a0, _a1, _a2
func (_m *NamedWriter) SetUserVODProperties(_a0 context.Context, _a1 int64, _a2 *models.UserVODPropertiesInput) (*dbmodels.UserVodProperties, error) {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 *dbmodels.UserVodProperties
	if rf, ok := ret.Get(0).(func(context.Context, int64, *models.UserVODPropertiesInput) *dbmodels.UserVodProperties); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dbmodels.UserVodProperties)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, int64, *models.UserVODPropertiesInput) error); ok {
		r1 = rf(_a0, _a1, _a2)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SetUserVideoPrivacyProperties provides a mock function with given fields: _a0, _a1, _a2
func (_m *NamedWriter) SetUserVideoPrivacyProperties(_a0 context.Context, _a1 int64, _a2 *models.UserVideoPrivacyPropertiesInput) (*models.UserVideoPrivacyProperties, error) {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 *models.UserVideoPrivacyProperties
	if rf, ok := ret.Get(0).(func(context.Context, int64, *models.UserVideoPrivacyPropertiesInput) *models.UserVideoPrivacyProperties); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*models.UserVideoPrivacyProperties)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, int64, *models.UserVideoPrivacyPropertiesInput) error); ok {
		r1 = rf(_a0, _a1, _a2)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SetViewcounts provides a mock function with given fields: _a0, _a1
func (_m *NamedWriter) SetViewcounts(_a0 context.Context, _a1 map[int]int64) ([]*dbmodels.Vod, error) {
	ret := _m.Called(_a0, _a1)

	var r0 []*dbmodels.Vod
	if rf, ok := ret.Get(0).(func(context.Context, map[int]int64) []*dbmodels.Vod); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*dbmodels.Vod)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, map[int]int64) error); ok {
		r1 = rf(_a0, _a1)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateAMR provides a mock function with given fields: _a0, _a1, _a2
func (_m *NamedWriter) UpdateAMR(_a0 context.Context, _a1 int, _a2 map[string]interface{}) (*dbmodels.AMR, error) {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 *dbmodels.AMR
	if rf, ok := ret.Get(0).(func(context.Context, int, map[string]interface{}) *dbmodels.AMR); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dbmodels.AMR)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, int, map[string]interface{}) error); ok {
		r1 = rf(_a0, _a1, _a2)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateSelectedThumbnail provides a mock function with given fields: _a0, _a1, _a2
func (_m *NamedWriter) UpdateSelectedThumbnail(_a0 context.Context, _a1 int64, _a2 string) error {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, int64, string) error); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// UpdateVod provides a mock function with given fields: _a0, _a1, _a2
func (_m *NamedWriter) UpdateVod(_a0 context.Context, _a1 int64, _a2 *models.VodUpdateInput) (*dbmodels.Vod, error) {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 *dbmodels.Vod
	if rf, ok := ret.Get(0).(func(context.Context, int64, *models.VodUpdateInput) *dbmodels.Vod); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dbmodels.Vod)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, int64, *models.VodUpdateInput) error); ok {
		r1 = rf(_a0, _a1, _a2)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateVodNotificationSettings provides a mock function with given fields: _a0, _a1, _a2, _a3
func (_m *NamedWriter) UpdateVodNotificationSettings(_a0 context.Context, _a1 int64, _a2 string, _a3 *models.VodNotificationSettingsInput) (*dbmodels.VodNotificationSettings, error) {
	ret := _m.Called(_a0, _a1, _a2, _a3)

	var r0 *dbmodels.VodNotificationSettings
	if rf, ok := ret.Get(0).(func(context.Context, int64, string, *models.VodNotificationSettingsInput) *dbmodels.VodNotificationSettings); ok {
		r0 = rf(_a0, _a1, _a2, _a3)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dbmodels.VodNotificationSettings)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, int64, string, *models.VodNotificationSettingsInput) error); ok {
		r1 = rf(_a0, _a1, _a2, _a3)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Utilization provides a mock function with given fields: _a0
func (_m *NamedWriter) Utilization(_a0 context.Context) float32 {
	ret := _m.Called(_a0)

	var r0 float32
	if rf, ok := ret.Get(0).(func(context.Context) float32); ok {
		r0 = rf(_a0)
	} else {
		r0 = ret.Get(0).(float32)
	}

	return r0
}
