package backend

import (
	"code.justin.tv/vod/vinyl/errors"
	"code.justin.tv/vod/vinyl/models"

	"golang.org/x/net/context"
)

// OwnerForRechat calls the appropriate readers to fetch owner information by the vod id.
func (b *Backend) OwnerForRechat(ctx context.Context, vodID int64) (*models.VodOwner, error) {
	var err error
	//Check if owner login information is available in the deprecated_vod_owner_used_for_rechat table
	rechatOwner, err := b.Reader.OwnerForRechat(ctx, vodID)
	if err != nil {
		return nil, err
	}

	//Get vod information and owner_id from vods table
	dbVods, err := b.Reader.GetVodsByID(ctx, []int64{vodID}, nil)
	if err != nil {
		return nil, err
	}

	if len(dbVods) == 0 {
		return nil, errors.NotFoundError{Type: "Vod", ID: int(vodID)}
	}

	//Populate the VodOwner object with information from db level
	res, err := convertVodOwner(rechatOwner, dbVods)
	if err != nil {
		return nil, err
	}

	return res, nil
}
