package backend

import (
	"code.justin.tv/vod/vinyl/errors"
	"code.justin.tv/vod/vinyl/models"
	"golang.org/x/net/context"
)

// Rebroadcast rebroadcasts a list of vods for a vod owner
func (b *Backend) Rebroadcast(ctx context.Context, vodIDs []int64, ownerID int64, streamKey string) error {
	if !b.ownerOwnsAllVodIDs(ctx, vodIDs, ownerID) {
		return errors.UnauthorizedError{}
	}

	err := b.Usher.Rebroadcast(vodIDs, streamKey)
	if err != nil {
		return err
	}

	emailArgs := map[string]interface{}{
		"usher_args": map[string]interface{}{
			"vod_ids":    vodIDs,
			"stream_key": streamKey,
		},
	}

	return b.RailsClient.SendEmail(ctx, ownerID, "rebroadcast_message", emailArgs)
}

func (b *Backend) ownerOwnsAllVodIDs(ctx context.Context, vodIDs []int64, ownerID int64) bool {
	dbVods, err := b.Reader.GetVodsByID(ctx, vodIDs, models.VodFilterNone())
	if err != nil {
		return true
	}

	res, err := convertVods(dbVods)
	if err != nil {
		return true
	}

	for _, v := range res {
		if v.OwnerID != ownerID {
			return false
		}
	}

	return true
}
