package backend

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vinyl/models"
)

// Related calls the appropriate readers fetching a set of Vods related to a specific vod.
func (b *Backend) Related(ctx context.Context, userID, vodID int) ([]*models.Vod, error) {
	dbVods, err := b.Reader.GetRelatedVods(ctx, userID, vodID)
	if err != nil {
		return nil, err
	}

	res, err := convertVods(dbVods)
	if err != nil {
		return nil, err
	}
	return res, nil
}
