package backend

import "golang.org/x/net/context"

// ResolveTrackAppeal calls the relevant writers to modify the track appeal status.
func (b *Backend) ResolveTrackAppeal(ctx context.Context, appealID int64, approve bool) error {
	amrID, vodID, err := b.Writer.ResolveTrackAppeal(ctx, appealID, approve)
	if err != nil {
		return err
	}

	if approve {
		err = b.Usher.UnmuteAudio(amrID, vodID)
		if err != nil {
			return err
		}
	}

	go b.trackMuteAppealResponse(amrID, vodID, approve)

	return err
}

func (b *Backend) trackMuteAppealResponse(amrID, vodID int64, approve bool) {
	event := map[string]interface{}{
		"amr_id":         amrID,
		"vod_id":         vodID,
		"appeal_success": approve,
	}

	b.SpadeClient.SendEvent("vod_mute_appeal_response", event)
}
