package backend

import (
	"fmt"

	"code.justin.tv/vod/vinyl/errors"
	edgemodels "code.justin.tv/vod/vinyl/models"
	"golang.org/x/net/context"
)

func (b *Backend) sendNotifications(ctx context.Context, vod *edgemodels.Vod, notificationSettings *edgemodels.VodNotificationSettings) error {
	switch notificationSettings.Type {
	case "email":
		err := b.PushyClient.SendVodUploadNotification(ctx, vod.OwnerID, vod.ID)
		if err != nil {
			return err
		}
	case "channel_feed":
		channelID := fmt.Sprintf("%d", vod.OwnerID)
		content := notificationSettings.CustomText.String
		_, err := b.AudreyClient.CreatePost(ctx, channelID, channelID, content, nil)

		if err != nil {
			return errors.AudreyClientError{err.Error()}
		}
	default:
		return errors.NotificationTypeInvalidError{Type: notificationSettings.Type}
	}
	return nil
}
