package backend

import (
	"time"

	"code.justin.tv/vod/vinyl/models"

	"golang.org/x/net/context"
)

// SetUserVideoPrivacyProperties calls the relevant writers to modify user video privacy properties.
func (b *Backend) SetUserVideoPrivacyProperties(ctx context.Context, userID int64, u *models.UserVideoPrivacyPropertiesInput) (*models.UserVideoPrivacyProperties, error) {
	u.CreatedAt = time.Now().UTC().Round(time.Second)
	u.UpdatedAt = time.Now().UTC().Round(time.Second)
	props, err := b.Writer.SetUserVideoPrivacyProperties(ctx, userID, u)
	if err != nil {
		return nil, err
	}
	return props, nil
}
