package backend

import (
	"time"

	"code.justin.tv/vod/vinyl/models"
	"golang.org/x/net/context"
)

// SetUserVODProperties calls the relevant writers to modify user VOD properties.
func (b *Backend) SetUserVODProperties(ctx context.Context, userID int64, u *models.UserVODPropertiesInput) (*models.UserVODProperties, error) {
	u.CreatedAt = time.Now().UTC().Round(time.Second)
	u.UpdatedAt = time.Now().UTC().Round(time.Second)
	props, err := b.Writer.SetUserVODProperties(ctx, userID, u)
	if err != nil {
		return nil, err
	}
	res, err := props.AsVinylUserVODProperties()
	if err != nil {
		return nil, err
	}
	return res, nil
}
