package backend

import "golang.org/x/net/context"

// SetViewcounts calls the appropriate writes to set view counts on a set of vods.
func (b *Backend) SetViewcounts(ctx context.Context, counts map[int]int64) error {
	dbVods, err := b.Writer.SetViewcounts(ctx, counts)
	if err != nil {
		return err
	}

	res, err := convertVods(dbVods)
	if err != nil {
		return err
	}

	go b.SearchIndexerAddBatch(context.Background(), res)
	return nil
}
