package backend

import (
	"net/http"
	"time"

	"code.justin.tv/vod/vinyl/models"
)

func (b *Backend) trackVodInit(vod *models.Vod, r *http.Request) {
	attributes := vod.SpadeAttributes(r)
	b.SpadeClient.SendEvent("vod_init", attributes)
}

func (b *Backend) trackVodCreateSuccess(vod *models.Vod) {
	attr := vod.SpadeAttributes(nil)
	attr["started_on"] = vod.StartedOn
	attr["offset"] = vod.Offset
	attr["broadcast_id"] = vod.BroadcastID
	attr["source_archive_id"] = vod.SourceArchiveID
	attr["input_resolution"] = "dummydata" // todo: fix this
	attr["upload_duration"] = int(time.Now().Sub(vod.CreatedAt).Seconds())
	b.SpadeClient.SendEvent("vod_create", attr)
}

func (b *Backend) trackVodCreateFailure(vod *models.Vod) {
	event := map[string]interface{}{
		"vod_id":        vod.ID,
		"channel_id":    vod.OwnerID,
		"created_by_id": vod.CreatedBy,
		"time":          time.Now(),
	}

	b.SpadeClient.SendEvent("vod_create_failure", event)
}

func (b *Backend) trackVodEdit(vod *models.Vod, r *http.Request) {
	attributes := vod.SpadeAttributes(r)
	attributes["backend"] = true // add this temp attribute for rollout purposes
	b.SpadeClient.SendEvent("vod_edit", attributes)
}

func (b *Backend) trackVodCreationStatus(vod *models.Vod) {
	attributes := vod.SpadeAttributes(nil)
	attributes["backend"] = true // add this temp attribute for rollout purposes
	b.SpadeClient.SendEvent("vod_creation_status", attributes)
}
