package backend

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vinyl/models"
)

// Top calls the appropriate
func (b *Backend) Top(ctx context.Context, broadcastType, language []string, game, period, sort string, limit int, offset int) ([]*models.Vod, error) {
	dbVods, err := b.Reader.GetTopVods(ctx, broadcastType, language, game, period, sort, limit, offset)
	if err != nil {
		return nil, err
	}

	res, err := convertVods(dbVods)
	if err != nil {
		return nil, err
	}
	return res, nil
}
