package backend

import (
	//"fmt"
	"time"

	"golang.org/x/net/context"

	"code.justin.tv/vod/vinyl/models"
)

// UpdateAMR calls the appropriate writers to update corresponding audible magic entries.
func (b *Backend) UpdateAMR(ctx context.Context, amrID int, updateFields map[string]interface{}) (*models.AMR, error) {
	// Set updated at field.
	updateFields["updated_at"] = time.Now().Round(time.Second)

	updatedAMR, err := b.Writer.UpdateAMR(ctx, amrID, updateFields)
	if err != nil {
		return nil, err
	}

	return updatedAMR.AsVinylAMR()
}
