package backend

import (
	"code.justin.tv/vod/vinyl/errors"
	"code.justin.tv/vod/vinyl/models"
	"golang.org/x/net/context"
)

// UpdateVodSearchIndexer updates the vod in the search index.
func (b *Backend) UpdateVodSearchIndexer(ctx context.Context, vodID int64) error {
	vods, err := b.Reader.GetVodsByID(ctx, []int64{vodID}, models.VodFilterNone())
	if err != nil {
		return err
	}
	if len(vods) != 1 {
		return errors.NotFoundError{}
	}
	vod, err := vods[0].AsVinylVod()
	if err != nil {
		return err
	}

	if vod.Watchable() {
		b.SearchIndexerAdd(ctx, vod)
	} else {
		b.SearchIndexerRemove(ctx, vod)
	}

	return nil
}
