package backend

import (
	"testing"

	"code.justin.tv/vod/vinyl/backend/mocks"
	dbmodels "code.justin.tv/vod/vinyl/datastore/vinyldb/models"
	"code.justin.tv/vod/vinyl/errors"
	"code.justin.tv/vod/vinyl/models"

	. "github.com/smartystreets/goconvey/convey"
	"golang.org/x/net/context"
)

func TestUpdateVods(t *testing.T) {
	Convey("Updating Vods", t, func() {
		mockWriter := &mocks.NamedWriter{}
		mockReader := &mocks.NamedReader{}
		backend := &Backend{
			Writer:       mockWriter,
			MasterReader: mockReader,
		}
		ctx := context.Context(nil)
		vodID := int64(1337)
		input := models.VodUpdateInput{}
		vod := &dbmodels.Vod{
			ID:     vodID,
			Status: models.StatusRecorded,
		}
		vods := []*dbmodels.Vod{vod}

		Convey("Cannot change status from recorded", func() {
			input.Status = models.NullString{models.StatusUnderReview, true}
			mockReader.On("GetVodsByID", ctx, []int64{vodID}, models.VodFilterNone()).Return(vods, nil)
			_, err := backend.UpdateVod(ctx, nil, vodID, input)
			So(err, ShouldHaveSameTypeAs, errors.InvalidStateTransitionError{})
		})
	})
}
