package vinyl

import (
	"encoding/json"
	"testing"

	. "github.com/smartystreets/goconvey/convey"
)

func TestUnmarshalThumbnailTemplateList(t *testing.T) {
	Convey("When unmarshalling ThumbnailTemplateList", t, func() {
		Convey("String values should return an empty list", func() {
			var ttl ThumbnailTemplateList
			err := json.Unmarshal([]byte(`"string"`), &ttl)
			So(err, ShouldBeNil)
			So(len(ttl), ShouldEqual, 0)
		})
		Convey("Properly formatted JSON thumbnail templates should return a list", func() {
			var ttl ThumbnailTemplateList
			err := json.Unmarshal([]byte(`[{"offset":15, "url":"yurl", "type":"instant", "path":"2exile"}]`), &ttl)
			So(err, ShouldBeNil)
			So(len(ttl), ShouldEqual, 1)
			So(ttl[0], ShouldResemble, ThumbnailTemplate{Offset: 15, URL: "yurl", Type: "instant", Path: "2exile"})
		})
		Convey("Other value should be an error", func() {
			var ttl ThumbnailTemplateList
			err := json.Unmarshal([]byte(`{"one":1}`), &ttl)
			So(err, ShouldNotBeNil)
		})
	})
}
