package clients

import (
	"code.justin.tv/common/config"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/credentials"
	"github.com/aws/aws-sdk-go/aws/session"
)

// The constants used to refer to AWS credentials used in sandstorm.
var (
	AWSAccessKeyID     = "aws_access_key_id"
	AWSSecretAccessKey = "aws_secret_access_key"
	AWSRegionName      = "aws-region-name"
)

func init() {
	config.Register(map[string]string{
		AWSAccessKeyID:     "",
		AWSSecretAccessKey: "",
		AWSRegionName:      "us-west-2",
	})
}

// CreateAWSCredentials takes local environment variables to
// set up a connection to aws services. Machines in AWS
// can connect properly because they have the right IAM profile
func CreateAWSCredentials() *credentials.Credentials {
	awsAccessKey := config.Resolve(AWSAccessKeyID)
	awsSecretKey := config.Resolve(AWSSecretAccessKey)
	if len(awsAccessKey) > 0 && len(awsSecretKey) > 0 {
		creds := credentials.NewStaticCredentials(awsAccessKey, awsSecretKey, "")
		return creds
	}
	return nil
}

// CreateAWSClientConfigs instantiates configs needed to open
// a connection to one of the aws services.
func CreateAWSClientConfigs() (*session.Session, *aws.Config) {
	mySession := session.New()

	region := config.Resolve(AWSRegionName)
	awsConfig := &aws.Config{
		Credentials: CreateAWSCredentials(),
		Region:      aws.String(region),
	}

	return mySession, awsConfig
}
