package clients

import (
	"log"

	"github.com/aws/aws-sdk-go/service/iam"
	"github.com/aws/aws-sdk-go/service/kinesis"

	"github.com/cactus/go-statsd-client/statsd"
)

// CreateKinesisConsumer setups a Kinesis consumer object with the relevant AWS credentials.
func CreateKinesisConsumer(stats statsd.Statter) *kinesis.Kinesis {
	session, awsConfig := CreateAWSClientConfigs()
	iamAPI := iam.New(session, awsConfig)
	accountInfo, err := iamAPI.ListAccountAliases(&iam.ListAccountAliasesInput{})
	if err != nil {
		return nil
	}
	log.Printf("Connecting to Kinesis stream in %v (%s)", *accountInfo.AccountAliases[0], *awsConfig.Region)

	kinesisAPI := kinesis.New(session, awsConfig)
	return kinesisAPI
}
