package clients

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/kinesis"
	"github.com/cactus/go-statsd-client/statsd"
)

// SearchIndexer is a client for making requests to search indexes
type SearchIndexer struct {
	streamName      string
	batchStreamName string
	kinesis         *kinesis.Kinesis
	stats           statsd.Statter
}

// NewSearchIndexer instantiates a new SearchIndexer with a kinesis connection
func NewSearchIndexer(streamName, batchStreamName string, stats statsd.Statter) *SearchIndexer {
	return &SearchIndexer{
		streamName:      streamName,
		batchStreamName: batchStreamName,
		kinesis:         CreateKinesisConsumer(stats),
		stats:           stats,
	}
}

// Index publishes to a searchindexer kinesis stream
func (s *SearchIndexer) Index(records []*kinesis.PutRecordsRequestEntry, statName string) {
	start := time.Now()
	if len(records) == 1 {
		params := &kinesis.PutRecordInput{
			Data:         records[0].Data,
			PartitionKey: records[0].PartitionKey,
			StreamName:   aws.String(s.streamName),
		}
		_, err := s.kinesis.PutRecord(params)
		if err != nil {
			fmt.Println(err)
		}
	} else {
		params := &kinesis.PutRecordsInput{
			Records:    records,
			StreamName: aws.String(s.batchStreamName),
		}
		_, err := s.kinesis.PutRecords(params)
		if err != nil {
			fmt.Println(err)
			return
		}
	}

	dur := time.Since(start)
	if statErr := s.stats.Inc("clients.search_indexer."+statName, 1, 0.1); statErr != nil {

	}
	if statErr := s.stats.TimingDuration("clients.search_indexer."+statName+".duration", dur, 0.1); statErr != nil {

	}
}
