package clients

import (
	"log"

	"code.justin.tv/common/config"
	"code.justin.tv/common/spade-client-go/spade"

	"golang.org/x/net/context"
)

// SpadeClient sends event data to Spade
type SpadeClient interface {
	SendEvent(name string, event map[string]interface{})
}

type spadeClient struct {
	spade spade.Client
}

// NewSpadeClient initializes a new SpadeClient if we're in production, otherwise returns a noop SpadeClient
func NewSpadeClient() (SpadeClient, error) {
	if config.Environment() != "production" {
		return MockSpadeClient{}, nil
	}

	client, err := spade.NewClient()
	if err != nil {
		return nil, err
	}

	return &spadeClient{
		spade: client,
	}, nil
}

// SendEvent sends a new event to spade
func (S *spadeClient) SendEvent(name string, event map[string]interface{}) {
	err := S.spade.TrackEvent(context.TODO(), name, event)
	if err != nil {
		log.Printf("Error sending spade event: %s", err.Error())
	}
}

// MockSpadeClient is a spade client that sends no events
type MockSpadeClient struct{}

// SendEvent is a mock
func (S MockSpadeClient) SendEvent(name string, event map[string]interface{}) {}

// // TrackAuthorizationDestroy is a mock
// func (S MockSpadeClient) TrackAuthorizationDestroy(userID, clientID string) {}
