#!/bin/bash
set -e
set -x

cd $GOPATH/src/code.justin.tv/vod/vinyl/configuration/lambda

mkdir -p _build
cp cloudformation.yaml _build/cloudformation.yaml

for dir in $(ls functions); do
  target="_build/$dir.zip"
  zip $target functions/$dir/* -x functions/$dir/cfn.yaml -j
  aws s3 cp $target s3://vinyl-lambda-functions/$dir.zip
  cat functions/$dir/cfn.yaml >> _build/cloudformation.yaml
done

aws s3 cp _build/cloudformation.yaml s3://cloudformation-templates.vinyl.twitch.tv/vinyl/lambda.yaml
aws cloudformation deploy --template-file _build/cloudformation.yaml --stack-name lambda

rm -rf _build/
