var http = require('http');

exports.handler = function(event, context) {
  console.log("Making request to Vinyl...");
  var req = http.request({
    host: 'vinyl-internal.production.us-west2.twitch.tv',
    port: '80',
    path: '/v1/vods/publish',
    method: 'POST'
  }, function(res) {
    console.log(`STATUS:  ${res.statusCode}`);
    console.log(`HEADERS: ${JSON.stringify(res.headers)}`);
    res.setEncoding('utf8');
    res.on('data', function(chunk) {
      console.log(`BODY: ${chunk}`);
    });
    res.on('end', function() {
      console.log(`Request complete.`);
    });
  });

  req.on('error', function(e) {
    console.log(`ERROR: ${e.message}`);
  })

  req.end();
};
