# Vod Data Fields
This document explains the meaning of each vod field by breaking them down into categories and explaining relevant topics along the way. Lets start with the simplest field:

- `id`: The auto-incrementing primary key

## Vod ownership
Vods are "owned" by a broadcaster or their editors. Owners of vods have the ability to edit vod metadata, delete a vod, or create highlights of a vod if it is a past broadcast.

- `owner_id`: The user id of the vod's owner
- `created_by_id`: The id of the user that created this vod. This will be either the broadcaster's user id or one of their current editors' user id (or a past editor who has since lost editor permissions).

## Editable metadata
Vods have many fields that are editable by their owners:

- `title`
- `game`
- `description`
- `language`
- `thumbnails`: an array of hashes. The first element in this list is the publicly viewable thumbnail. The other thumbnails can be promoted to become the public thumbnail by the vod owners. Owners are also able to insert a custom thumbnail into this list.
- `tag_hstore`: An array of tags describing the video
- `viewable`: can be "private", "unlisted", "public". "private" means this vod is only viewable by owners. "unlisted" means it's visible to the public, but not listed in search. "public" means it is viewable to the public and listed in search.
- `viewable_at`: If this date is set, the viewable state will be automatically set to "public" on this date. This field is used to implement vod scheduled releases.

## Vod types and status

- `broadcast_type`: "archive" if this vod is a past broadcast. Past broadcasts are the vods that are generated when broadcasters go live on Twitch. "highlight" for a highlight, which is a manually created subsection of a past broadcast. "upload" is a vod that is uploaded directly to Twitch through the upload tool - uploads were never broadcast live.
- `status`: Each of these 3 broadcast types vods flow through a number of states before they are ready to be watched.

Past broadcasts go from "recording" to "recorded". "recording" past broadcasts are watchable by the public, but their final durations will not update as the live broadcast continues.

Highlights go from "unprocessed" to "recorded". They are unwatchable (usually only for a few milliseconds) while they are still being processed.

Uploads go from "created", "uploading", "pending_transcode", "transcoding", "recorded". It can also be "failed" if it fails at any of these steps. Only "recorded" uploads are publicly viewable.

## Vod Deletion
Past broadcasts on Twitch live for 14 days on Twitch for most users, after which they get cleaned up and deleted from this database by the offline deletion cron. Partners or turbo users get to keep their vods for 60 days. And we also mark a select few channels to save their vods forever. It's important to note that a vod on Twitch is both an entry in this database and a set of files on disk. After the vod's natural expiration date, either 14 or 60 days, the vod is "hard deleted", meaning its DB row and its files on disk are completely removed. Highlights and uploads are saved forever, but at time of writing, past broadcasts are the vast majority of vod content stored on Twitch.

- `deleted`: Vod owners have the ability to set this to true. If true, this vod is "soft deleted". The vod is completely hidden from all users, including the owner. The video files still exist on disk though, and Twitch staff have the ability to go into the admin panel to undelete the vod, which will make the vod correctly play again.
- `delete_at`: an operational override date for vod deletion. Users cannot set this date, but in our systems we will set this to make hard deletion happen on this date regardless of the natural expiration. We can use this field to extend or shrink the life of a vod.

## Fields that describe to our systems where to find the video files to play.
- `origin`: the service we use to store files. can be either "s3" for s3 or null for swift.
- `manifest`: the name of the manifest file. often is "index-dvr.m3u8" for past broadcasts, and "highlight-:highlight_id.m3u8" for highlights
- `uri`: the path to the vod's directory where files are kept

## Metadata used by the video player when playing back the vod
- `formats`
- `codecs`
- `bitrates`
- `resolutions`
- `display_names`
- `playlist_preferences`
- `fps`

## Other misc fields
- `created_at`: timestamp that this row was inserted into the DB
- `updated_at`: timestamp that this row was last updated
- `broadcaster_software`: this is supposed to be a string that denotes the broadcaster software used in the creation of this vod, like OBS, XBOX, PS4, etc. It is currently set to null for all vods
- `broadcast_id`: the id of the live broadcast that this vod originated from. This value is generated by usherdb. this is used to look up highlights that are created from archives
- `source_archive_id`: for highlights, this is the id of the archive that the highlight was made from. We use this for some complicated muting queries.
- `started_on`: the timestamp that this vod started recording at. for "archive" it is the timestamp that the broadcast started. for "highlight", it is the time in the past broadcast that the highlight started. for "upload" it's the time that the upload was created.
- `offset`: for highlights, this is how many seconds offset from the beginning of the past broadcast the highlight starts. for past broadcasts and uploads this value means nothing.
- `duration`: the duration of the video in seconds
- `views_count`: # of views this vod has. this field is updated by the web/countess service and can be up to 15 mins delayed at time of writing.
- `published_at`: timestamp of when the archive/highlight/upload was first viewable to public, viewable to public means vod is watchable and not marked private

## What makes a vod watchable?
If a vod is soft deleted ("deleted" == true), it is gone from the website and users cannot find the vod. The files still exist in our servers though, and it is viewable in admin-panel.

If a vod is hard deleted, the row is removed from the database, the files are deleted, and it is completely gone.

For existing vods, though, there is the concept of "watchable". Watchable vods are visible to end users and to the broadcasters. Unwatchable vods are not viewable to end users, but the broadcaster can see their own unwatchable vods in their video manager. At time of writing, "watchable" can be expressed as:
```
status IN ('recording', 'recorded') AND viewable = 'public'
```
