package testds

import "golang.org/x/net/context"

// constants used for tests
const (
	TestID     = 123
	TestValue  = "hello"
	TestValue2 = "world"
	TestBadID  = "lkajsd"
	TestCount  = 10
)

// Backend is the test backend implementation.
type Backend struct{}

// New test impl
func New() *Backend {
	return &Backend{}
}

// Name returns the name of the test backend.
func (B *Backend) Name() string {
	return "test datastore"
}

// Utilization return 0 for the test database.
func (B *Backend) Utilization(ctx context.Context) float32 {
	return float32(0)
}

// Health returns nil for the test database.
func (B *Backend) Health(ctx context.Context) error {
	return nil
}
