package vinyldb

import (
	"log"
	"strconv"
	"strings"

	"golang.org/x/net/context"

	"code.justin.tv/chat/db"
	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"
	"code.justin.tv/vod/vinyl/datastore/vinyldb/utils"
)

// AttachVodThumbnails queries for the given Vods' VodThumbnails
func (b *Backend) AttachVodThumbnails(ctx context.Context, vods []*models.Vod) error {
	if len(vods) == 0 {
		return nil
	}

	vodIDs := []string{}
	vodsMap := map[int64]*models.Vod{}
	for _, vod := range vods {
		vodIDs = append(vodIDs, strconv.FormatInt(vod.ID, 10))
		vodsMap[vod.ID] = vod
	}

	query := db.BuildQuery(
		"SELECT id, vod_id, path, \"offset\", type FROM vod_thumbnails WHERE vod_id IN (", strings.Join(vodIDs, ","), ")",
	)
	rows, err := b.conn.Query(ctx, "attach_vod_thumbnails", query)
	if err != nil {
		return err
	}
	defer utils.CloseRows(rows, b.logger)

	for rows.Next() {
		thumb := &models.VodThumbnail{}
		err = rows.Scan(&thumb.ID, &thumb.VodID, &thumb.Path, &thumb.Offset, &thumb.Type)
		if err != nil {
			return err
		}

		vod, ok := vodsMap[thumb.VodID]
		if !ok {
			log.Println("Error attaching VodThumbnails to Vods: Missing vod", thumb.VodID, "for thumbnail ", thumb.ID)
			continue
		}
		vod.Thumbnails = append(vod.Thumbnails, thumb)
	}

	return nil
}
