package vinyldb

import (
	"strings"

	"code.justin.tv/chat/db"
	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"
	"code.justin.tv/vod/vinyl/datastore/vinyldb/utils"
	edgemodels "code.justin.tv/vod/vinyl/models"
	"golang.org/x/net/context"
)

// CreateAMRs calls vinylDB to insert the audible magic response object.
func (b *Backend) CreateAMRs(ctx context.Context, vodID int64, amrs []*edgemodels.AMR, forceIDs bool) ([]int64, error) {
	ret := []int64{}
	datastoreAMR := []*models.AMR{}
	for _, amr := range amrs {
		dAMR, err := models.FromVinylAMR(amr)
		if err != nil {
			return ret, err
		}
		datastoreAMR = append(datastoreAMR, dAMR)
	}

	valueParams := []string{}
	createFieldsLength := len(models.AMRCreateFields)
	createFields := models.AMRCreateFields
	if forceIDs {
		createFieldsLength++
		createFields = append(createFields, "id")
	}
	numCounter := 1
	values := []interface{}{}
	for _, dAMR := range datastoreAMR {
		valuesList := dAMR.ValuesList()
		if forceIDs {
			valuesList = append(valuesList, dAMR.AudibleMagicResponseID)
		}
		valueParams = append(valueParams, BuildValuesList(numCounter, createFieldsLength))
		values = append(values, valuesList...)
		numCounter += createFieldsLength
	}

	query := db.BuildQuery(
		"INSERT INTO", models.AMRTableName,
		BuildParamList(createFields),
		"VALUES", strings.Join(valueParams, ","),
		"RETURNING id")

	rows, err := b.conn.Query(ctx, "create_amrs", query, values...)
	if err != nil {
		return ret, err
	}

	defer utils.CloseRows(rows, b.logger)

	for i := 0; rows.Next(); i++ {
		var amrID int64
		if err = rows.Scan(&amrID); err != nil {
			return ret, err
		}
		ret = append(ret, amrID)
	}

	return ret, nil
}
