package vinyldb

import (
	"testing"
	"time"

	"github.com/DATA-DOG/go-sqlmock"
	. "github.com/smartystreets/goconvey/convey"

	"code.justin.tv/vod/vinyl/models"
	"golang.org/x/net/context"
)

func TestCreateAMRs(t *testing.T) {
	Convey("Creating AMRs", t, func() {
		mock, backend := Setup()

		Convey("Inserts values and runs with 1 AMR", func() {
			now := time.Now().Round(time.Second)
			amrs := []*models.AMR{
				&models.AMR{
					VodID:     34,
					IsMatch:   true,
					UpdatedAt: now,
					CreatedAt: now,
				}}

			query := `INSERT INTO audible_magic_responses (.+) VALUES (.+) RETURNING id`
			rows := sqlmock.NewRows([]string{"id"}).AddRow(1)
			mock.ExpectQuery(query).WithArgs(
				34, nil, nil, nil, nil, nil, nil, nil,
				true, nil, nil, nil, nil, nil, nil,
				now, now, nil, nil, nil).WillReturnRows(rows)

			amrIDs, err := backend.CreateAMRs(context.Background(), 0, amrs, false)
			So(mock.ExpectationsWereMet(), ShouldBeNil)
			So(amrIDs, ShouldResemble, []int64{1})
			So(err, ShouldBeNil)
		})

		Convey("Inserts multiple values together", func() {
			amrs := []*models.AMR{
				&models.AMR{
					VodID: 34,
				},
				&models.AMR{
					VodID: 234,
				},
			}
			query := `INSERT INTO audible_magic_responses (.+) VALUES (.+),(.+) RETURNING id`
			rows := sqlmock.NewRows([]string{"id"}).AddRow(1).AddRow(2)
			mock.ExpectQuery(query).WillReturnRows(rows)

			amrIDs, err := backend.CreateAMRs(context.Background(), 0, amrs, false)
			So(mock.ExpectationsWereMet(), ShouldBeNil)
			So(amrIDs, ShouldResemble, []int64{1, 2})
			So(err, ShouldBeNil)
		})
	})
}
