package vinyldb

import (
	"errors"
	"strconv"
	"strings"

	"code.justin.tv/chat/db"
	"code.justin.tv/vod/vinyl/models"
	"golang.org/x/net/context"
)

// CreateThumbnails creates thumbnails for the given vod
func (b *Backend) CreateThumbnails(ctx context.Context, vodID int64, newThumbnails models.Thumbnails) (models.Thumbnails, error) {
	if len(newThumbnails) == 0 {
		return b.GetVodThumbnails(ctx, vodID)
	}

	valuesParams := []string{}
	values := []interface{}{}
	i := 1
	for _, thumbnail := range newThumbnails {
		valuesParams = append(valuesParams, BuildValuesList(i, 4))
		values = append(values, vodID, thumbnail.Path, thumbnail.Offset, thumbnail.Type())
		i += 4
	}
	query := db.BuildQuery(
		"INSERT INTO vod_thumbnails",
		BuildParamList([]string{"vod_id", "path", "\"offset\"", "type"}),
		"VALUES", strings.Join(valuesParams, ","),
		"ON CONFLICT DO NOTHING",
	)
	_, err := b.conn.Exec(context.Background(), "insert_vod_thumbnails", query, values...)
	if err != nil {
		return models.Thumbnails{}, errors.New("Unable to store vod's new thumbnails" + strconv.FormatInt(vodID, 10) + ": " + err.Error())
	}

	query = db.BuildQuery(
		"UPDATE vods",
		"SET selected_thumbnail_id = (SELECT id FROM vod_thumbnails WHERE vod_id = ", db.Param, " LIMIT 1)",
		"WHERE id = ", db.Param, "AND selected_thumbnail_id IS null",
	)
	_, err = b.conn.Exec(ctx, "update_selected_thumbnail_id", query, vodID, vodID)
	if err != nil {
		return models.Thumbnails{}, errors.New("Unable to update vod's selected thumbnail")
	}
	return b.GetVodThumbnails(ctx, vodID)
}
