package vinyldb

import (
	"strings"

	"code.justin.tv/chat/db"
	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"
	"code.justin.tv/vod/vinyl/datastore/vinyldb/utils"
	edgemodels "code.justin.tv/vod/vinyl/models"
	"golang.org/x/net/context"
)

// CreateTrackAppeals calls vinylDB to insert the track appeal entry.
func (b *Backend) CreateTrackAppeals(ctx context.Context, tas []*edgemodels.TrackAppeal, vodAppealID int64, forceIDs bool) ([]int64, error) {
	ret := []int64{}

	datastoreTAs := []*models.TrackAppeal{}
	for _, ta := range tas {
		dTA, err := models.FromVinylTrackAppeal(ta)
		if err != nil {
			return ret, err
		}
		datastoreTAs = append(datastoreTAs, dTA)
	}

	valueParams := []string{}
	createFieldsLength := len(models.TrackAppealCreateFields)
	createFields := models.TrackAppealCreateFields
	if forceIDs {
		createFieldsLength++
		createFields = append(createFields, "id")
	}
	numCounter := 1
	values := []interface{}{}
	for _, dTA := range datastoreTAs {
		valuesList := dTA.ValuesList()
		if forceIDs {
			valuesList = append(valuesList, dTA.TrackAppealID)
		}
		valueParams = append(valueParams, BuildValuesList(numCounter, createFieldsLength))
		values = append(values, valuesList...)
		numCounter += createFieldsLength
	}

	query := db.BuildQuery(
		"INSERT INTO track_appeals",
		BuildParamList(createFields),
		"VALUES", strings.Join(valueParams, ","),
		"RETURNING id")

	rows, err := b.conn.Query(ctx, "create_track_appeals", query, values...)
	if err != nil {
		return ret, err
	}

	defer utils.CloseRows(rows, b.logger)

	for i := 0; rows.Next(); i++ {
		var trackAppealsID int64
		if err = rows.Scan(&trackAppealsID); err != nil {
			return ret, err
		}
		ret = append(ret, trackAppealsID)
	}

	return ret, nil
}
