package vinyldb

import (
	"regexp"
	"testing"
	"time"

	. "github.com/smartystreets/goconvey/convey"

	"code.justin.tv/vod/vinyl/models"
	sqlmock "github.com/DATA-DOG/go-sqlmock"
	"golang.org/x/net/context"
)

//should probably just mock out readvodrows
func TestCreateTrackAppeals(t *testing.T) {
	Convey("Creating track appeals", t, func() {
		mock, backend := Setup()

		Convey("Inserts values and runs with 1 TrackAppeal", func() {
			now := time.Now().Round(time.Second)
			tas := []*models.TrackAppeal{
				&models.TrackAppeal{
					AudibleMagicResponseID: 17,
					VodAppealID:            42,
					Reason:                 "permission_rights",
					CreatedAt:              now,
					UpdatedAt:              now,
				}}

			query := `INSERT INTO track_appeals ` +
				`(audible_magic_response_id,vod_appeal_id,reason,created_at,updated_at,resolved_at) ` +
				`VALUES ($1,$2,$3,$4,$5,$6) ` +
				`RETURNING id`
			rows := sqlmock.NewRows([]string{"id"}).AddRow(1)
			mock.ExpectQuery(regexp.QuoteMeta(query)).WithArgs(
				17, 42, "permission_rights", now, now, nil).WillReturnRows(rows)
			ids, err := backend.CreateTrackAppeals(context.Background(), tas, 42, false)
			So(mock.ExpectationsWereMet(), ShouldBeNil)
			So(ids, ShouldResemble, []int64{1})
			So(err, ShouldBeNil)
		})

		Convey("Inserts multiple values together", func() {
			now := time.Now().Round(time.Second)
			tas := []*models.TrackAppeal{
				&models.TrackAppeal{
					AudibleMagicResponseID: 17,
					VodAppealID:            42,
					Reason:                 "permission_rights",
					CreatedAt:              now,
					UpdatedAt:              now,
				},
				&models.TrackAppeal{
					AudibleMagicResponseID: 18,
					VodAppealID:            42,
					Reason:                 "fair_use",
					CreatedAt:              now,
					UpdatedAt:              now,
				},
			}

			query := `INSERT INTO track_appeals ` +
				`(audible_magic_response_id,vod_appeal_id,reason,created_at,updated_at,resolved_at) ` +
				`VALUES ($1,$2,$3,$4,$5,$6),($7,$8,$9,$10,$11,$12) ` +
				`RETURNING id`
			rows := sqlmock.NewRows([]string{"id"}).AddRow(1).AddRow(2)
			mock.ExpectQuery(regexp.QuoteMeta(query)).WithArgs(
				17, 42, "permission_rights", now, now, nil,
				18, 42, "fair_use", now, now, nil).WillReturnRows(rows)
			ids, err := backend.CreateTrackAppeals(context.Background(), tas, 42, false)
			So(mock.ExpectationsWereMet(), ShouldBeNil)
			So(ids, ShouldResemble, []int64{1, 2})
			So(err, ShouldBeNil)
		})

	})
}
