package vinyldb

import (
	"errors"
	"strconv"
	"time"

	"golang.org/x/net/context"

	"code.justin.tv/chat/db"
	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"
	"code.justin.tv/vod/vinyl/datastore/vinyldb/utils"
	edgemodels "code.justin.tv/vod/vinyl/models"
)

// CreateVodAppeal calls vinylDB to create the Vod appeal entry.
// If it already exists, it will return the ID of the of the existing
// entry.
func (b *Backend) CreateVodAppeal(ctx context.Context, vodAppeal *edgemodels.VodAppeal, forceID bool) (int64, error) {
	datastoreVodAppeal, err := models.FromVinylVodAppeal(vodAppeal)
	if err != nil {
		return 0, err
	}

	var vodAppealID int64

	paramNames := models.VodAppealCreateFields
	valuesList := datastoreVodAppeal.ValuesList()
	if forceID {
		paramNames = append(paramNames, "id")
		valuesList = append(valuesList, vodAppeal.VodAppealID)
	}
	now := time.Now().UTC().Round(time.Second)
	valuesList = append(valuesList, now)
	valueParams := BuildValuesList(1, len(paramNames))
	query := db.BuildQuery(
		"INSERT INTO vod_appeals",
		BuildParamList(paramNames),
		"VALUES", valueParams,
		"ON CONFLICT (vod_id)",
		"DO UPDATE",
		"SET updated_at =",
		"$"+strconv.Itoa(len(paramNames)+1)+",",
		"resolved_at = NULL",
		"RETURNING id")

	rows, err := b.conn.Query(ctx, "upsert_vod_appeal", query, valuesList...)
	if err != nil {
		return 0, err
	}

	defer utils.CloseRows(rows, b.logger)

	if !rows.Next() {
		return 0, errors.New("could not insert vod appeal")
	}

	if err = rows.Scan(&vodAppealID); err != nil {
		return 0, err
	}
	return vodAppealID, nil
}
