package vinyldb

import (
	"regexp"
	"testing"
	"time"

	"github.com/DATA-DOG/go-sqlmock"
	. "github.com/smartystreets/goconvey/convey"

	"code.justin.tv/vod/vinyl/models"
	"golang.org/x/net/context"
)

//should probably just mock out readvodrows
func TestCreateVodAppeal(t *testing.T) {
	now := time.Now().Round(time.Second)
	var vodAppeal *models.VodAppeal
	Convey("Creating VodAppeal", t, func() {
		mock, backend := Setup()

		Convey("Inserts values and runs with 1 VodAppeal", func() {
			vodAppeal = &models.VodAppeal{
				CreatedAt:      now,
				UpdatedAt:      now,
				VodID:          34,
				Priority:       false,
				FullName:       "Smitty Werbenjaegermanjensen",
				StreetAddress1: "4 Privet Drive",
				StreetAddress2: "White House Ave",
				City:           "Cupertino",
				State:          "Alaska",
				Zipcode:        "11111",
				Country:        "Russia",
			}

			query := `INSERT INTO vod_appeals ` +
				`(resolved_at,created_at,updated_at,vod_id,priority,full_name,` +
				`street_address_1,street_address_2,city,state,zipcode,country) ` +
				`VALUES ($1,$2,$3,$4,$5,$6,$7,$8,$9,$10,$11,$12) ` +
				`ON CONFLICT (vod_id) DO UPDATE SET updated_at = $13, ` +
				`resolved_at = NULL ` +
				`RETURNING id`
			rows := sqlmock.NewRows([]string{"id"}).AddRow(34)
			mock.ExpectQuery(regexp.QuoteMeta(query)).WithArgs(
				nil, now, now, 34, false, "Smitty Werbenjaegermanjensen", "4 Privet Drive",
				"White House Ave", "Cupertino", "Alaska", "11111", "Russia", AnyTime{}).WillReturnRows(rows)

			_, err := backend.CreateVodAppeal(context.Background(), vodAppeal, false)
			So(mock.ExpectationsWereMet(), ShouldBeNil)
			So(err, ShouldBeNil)
		})

		Convey("Handles empty fields", func() {
			vodAppeal = &models.VodAppeal{
				CreatedAt: now,
				UpdatedAt: now,
				VodID:     34,
			}

			query := `INSERT INTO vod_appeals ` +
				`(resolved_at,created_at,updated_at,vod_id,priority,full_name,` +
				`street_address_1,street_address_2,city,state,zipcode,country) ` +
				`VALUES ($1,$2,$3,$4,$5,$6,$7,$8,$9,$10,$11,$12) ` +
				`ON CONFLICT (vod_id) DO UPDATE SET updated_at = $13, ` +
				`resolved_at = NULL ` +
				`RETURNING id`
			rows := sqlmock.NewRows([]string{"id"}).AddRow(34)
			mock.ExpectQuery(regexp.QuoteMeta(query)).WithArgs(
				nil, now, now, 34, false, "", "", "", "", "", "", "", AnyTime{}).WillReturnRows(rows)

			_, err := backend.CreateVodAppeal(context.Background(), vodAppeal, false)
			So(mock.ExpectationsWereMet(), ShouldBeNil)
			So(err, ShouldBeNil)
		})
	})
}
