package vinyldb

import (
	"log"

	"code.justin.tv/chat/db/dbtest"

	"github.com/DATA-DOG/go-sqlmock"
	"github.com/cactus/go-statsd-client/statsd"
)

func Setup() (sqlmock.Sqlmock, *Backend) {
	stats, err := statsd.NewNoopClient()
	if err != nil {
		log.Fatalf("failed to make stats client")
	}
	testDB, mock, err := sqlmock.New()
	if err != nil {
		log.Fatalf("failed to make sqlmock")
	}
	backend := New(dbtest.NewMockDB(testDB), "mocked_db", stats, nil)
	return mock, backend
}
