package vinyldb

import (
	"code.justin.tv/chat/db"
	"golang.org/x/net/context"
)

// DeleteThumbnail deletes a thumbnail using vodID and path
func (b *Backend) DeleteThumbnail(ctx context.Context, vodID int64, path string) error {
	query := db.BuildQuery(
		"DELETE FROM vod_thumbnails WHERE vod_id = ", db.Param, "AND path = ", db.Param,
		"RETURNING id",
	)
	row := b.conn.QueryRow(ctx, "delete_vod_thumbnail", query, vodID, path)
	var thumbID int64
	err := row.Scan(&thumbID)
	if err != nil {
		return err
	}

	query = db.BuildQuery(
		"UPDATE vods",
		"SET selected_thumbnail_id = (SELECT id FROM vod_thumbnails WHERE vod_id = ", db.Param, " LIMIT 1)",
		"WHERE id = ", db.Param, " AND selected_thumbnail_id = ", db.Param,
	)
	_, err = b.conn.Exec(ctx, "update_selected_thumbnail_id", query, vodID, vodID, thumbID)
	return err
}
