package vinyldb

import (
	"code.justin.tv/chat/db"
	"golang.org/x/net/context"
)

// DeleteThumbnails deletes a vod's generated thumbnails
func (b *Backend) DeleteThumbnails(ctx context.Context, vodID int64) error {
	query := db.BuildQuery(
		"DELETE FROM vod_thumbnails WHERE vod_id = ", db.Param, "AND type = 'generated'",
		"RETURNING id",
	)
	rows, err := b.conn.Query(context.Background(), "delete_vod_thumbnails", query, vodID)
	if err != nil {
		return err
	}
	thumbIDs := []interface{}{}
	for rows.Next() {
		var id int64
		err = rows.Scan(&id)
		if err != nil {
			return err
		}
		thumbIDs = append(thumbIDs, id)
	}

	if len(thumbIDs) == 0 {
		return nil
	}

	query = db.BuildQuery(
		"UPDATE vods",
		"SET selected_thumbnail_id = (SELECT id FROM vod_thumbnails WHERE vod_id = ", db.Param, " LIMIT 1)",
		"WHERE id = ", db.Param, " AND selected_thumbnail_id IN ", db.Params(len(thumbIDs)),
	)

	queryArgs := []interface{}{vodID, vodID}
	queryArgs = append(queryArgs, thumbIDs...)

	_, err = b.conn.Exec(ctx, "update_selected_thumbnail_id", query, queryArgs...)
	return err
}
