package vinyldb

import (
	"code.justin.tv/chat/db"
	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"
	"golang.org/x/net/context"
)

// DeleteVods calls into the VinylDB to remove vods rows
func (b *Backend) DeleteVods(ctx context.Context, vodIDs []int64) error {
	query := db.BuildQuery(
		models.DestroyVodsQuery(),
		"WHERE id IN ", db.Params(len(vodIDs)),
	)
	_, err := b.conn.Exec(ctx, "delete_vod", query, emptyInterfaceVodIDs(vodIDs)...)
	return err
}

func emptyInterfaceVodIDs(vodIDs []int64) []interface{} {
	results := []interface{}{}
	for _, vodID := range vodIDs {
		results = append(results, vodID)
	}
	return results
}
