package vinyldb

import (
	"regexp"
	"testing"

	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"
	"github.com/DATA-DOG/go-sqlmock"

	. "github.com/smartystreets/goconvey/convey"
	"golang.org/x/net/context"
)

func TestDeleteVods(t *testing.T) {
	Convey("DeleteVods", t, func() {
		mock, backend := Setup()
		ids := []int64{123, 456, 789}
		Convey("runs the correct query", func() {
			query := regexp.QuoteMeta(models.DestroyVodsQuery() + ` WHERE id IN ($1, $2, $3)`)
			mock.ExpectExec(query).WithArgs(ids[0], ids[1], ids[2]).WillReturnResult(sqlmock.NewResult(1, 1))
			err := backend.DeleteVods(context.Background(), ids)
			So(mock.ExpectationsWereMet(), ShouldBeNil)
			So(err, ShouldBeNil)
		})
	})
}
