package vinyldb

import (
	"code.justin.tv/chat/db"
	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"
	"golang.org/x/net/context"
)

// FollowedVods calls into vinylDB to find vods recently created by the followed list of users.
func (b *Backend) FollowedVods(ctx context.Context, followedIDs []int, broadcastType, language, status []string, sort string, limit, offset int) ([]*models.Vod, error) {
	res := []*models.Vod{}

	params := []interface{}{}
	queryParts := []interface{}{models.FetchAllVODFieldsQuery()}

	for _, b := range broadcastType {
		params = append(params, b)
	}
	queryParts = append(queryParts, "WHERE broadcast_type IN ", db.Params(len(broadcastType)))
	queryParts = append(queryParts, models.Watchable())

	if len(language) > 0 {
		for _, l := range language {
			params = append(params, l)
		}
		queryParts = append(queryParts, "AND language IN ", db.Params(len(language)))
	}

	if len(status) > 0 {
		for _, s := range status {
			params = append(params, s)
		}
		queryParts = append(queryParts, "AND status IN ", db.Params(len(status)))
	}

	queryParts = append(queryParts, "AND owner_id IN (")
	for _, followedID := range followedIDs {
		params = append(params, followedID)
		queryParts = append(queryParts, db.Param, ",")
	}
	queryParts = queryParts[:len(queryParts)-1] // remove the last comma
	queryParts = append(queryParts, ")")

	queryParts = append(queryParts, pgSortQueryPart(sort))

	params = append(params, limit, offset)
	queryParts = append(queryParts, "LIMIT", db.Param, "OFFSET", db.Param)

	query := db.BuildQuery(queryParts...)

	rows, err := b.conn.Query(ctx, "get_followed_vods", query, params...)
	res, err = models.ReadVodRows(rows, err, b.logger)
	err = b.AttachVodThumbnails(ctx, res)
	if err != nil {
		return nil, err
	}

	return res, nil

}
