package vinyldb

import (
	"testing"

	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"

	. "github.com/smartystreets/goconvey/convey"
	"golang.org/x/net/context"
)

//should probably just mock out readvodrows
func TestFollowedVods(t *testing.T) {
	language := []string{}
	status := []string{}
	Convey("Followed vods", t, func() {
		mock, reader := Setup()
		ids := []int{123, 456}
		limit := 20
		offset := 0
		sort := "views"
		Convey("With broadcast type as archive,highlight should run the right query", func() {
			broadcastType := []string{"archive", "highlight"}
			query := models.FetchAllVODFieldsQuery() + ` WHERE broadcast_type IN (.+)` +
				` AND owner_id IN (.+)` +
				` ORDER BY views_count DESC LIMIT (.+) OFFSET (.+)`
			mock.ExpectQuery(query).WithArgs(broadcastType[0], broadcastType[1], ids[0], ids[1], limit, offset)
			_, err := reader.FollowedVods(context.Background(), ids, broadcastType, language, status, sort, limit, offset)
			So(mock.ExpectationsWereMet(), ShouldBeNil)
			So(err, ShouldBeNil)
		})

		Convey("With broadcast type as archive should run the right query", func() {
			broadcastType := []string{"archive"}
			query := models.FetchAllVODFieldsQuery() + ` WHERE broadcast_type IN (.+)` +
				` AND owner_id IN (.+)` +
				` ORDER BY views_count DESC LIMIT (.+) OFFSET (.+)`
			mock.ExpectQuery(query).WithArgs(broadcastType[0], ids[0], ids[1], limit, offset)
			_, err := reader.FollowedVods(context.Background(), ids, broadcastType, language, status, sort, limit, offset)
			So(mock.ExpectationsWereMet(), ShouldBeNil)
			So(err, ShouldBeNil)
		})

		Convey("with language should run the right query", func() {
			broadcastType := []string{"archive"}
			language = []string{"en"}
			query := models.FetchAllVODFieldsQuery() + ` WHERE broadcast_type IN (.+)` +
				` AND language IN (.+)` +
				` AND owner_id IN (.+)` +
				` ORDER BY views_count DESC LIMIT (.+) OFFSET (.+)`
			mock.ExpectQuery(query).WithArgs(broadcastType[0], language[0], ids[0], ids[1], limit, offset)
			_, err := reader.FollowedVods(context.Background(), ids, broadcastType, language, status, sort, limit, offset)
			So(mock.ExpectationsWereMet(), ShouldBeNil)
			So(err, ShouldBeNil)
		})

		Convey("with status should run the right query", func() {
			broadcastType := []string{"archive"}
			language = []string{}
			status = []string{"en"}
			query := models.FetchAllVODFieldsQuery() + ` WHERE broadcast_type IN (.+)` +
				` AND status IN (.+)` +
				` AND owner_id IN (.+)` +
				` ORDER BY views_count DESC LIMIT (.+) OFFSET (.+)`
			mock.ExpectQuery(query).WithArgs(broadcastType[0], status[0], ids[0], ids[1], limit, offset)
			_, err := reader.FollowedVods(context.Background(), ids, broadcastType, language, status, sort, limit, offset)
			So(mock.ExpectationsWereMet(), ShouldBeNil)
			So(err, ShouldBeNil)
		})

	})
}
