package vinyldb

import (
	"code.justin.tv/chat/db"
	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"
	"golang.org/x/net/context"
)

// GetAMRs calls vinylDB to fetch the audible magic responses associated with a vod.
func (b *Backend) GetAMRs(ctx context.Context, vodID int) ([]*models.AMR, error) {
	res := []*models.AMR{}
	query := db.BuildQuery(
		models.FetchAMRQuery(),
		"WHERE vod_id =", db.Param,
		"ORDER BY id",
	)
	rows, err := b.conn.Query(ctx, "get_amrs", query, vodID)
	res, err = models.ReadAMRRows(rows, err, b.logger)
	return res, err
}
