package vinyldb

import (
	"golang.org/x/net/context"

	"code.justin.tv/chat/db"
	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"
)

// GetAMRsByVodIDs calls vinylDB to fetch the audible magic responses associated
// with the vod ids.
func (b *Backend) GetAMRsByVodIDs(ctx context.Context, vodIDs []int64) ([]*models.AMR, error) {
	query := db.BuildQuery(
		models.FetchAMRQuery(),
		"WHERE vod_id IN",
		db.Params(len(vodIDs)),
		"ORDER BY id ASC",
	)

	params := make([]interface{}, len(vodIDs))
	for i, vodID := range vodIDs {
		params[i] = vodID
	}

	rows, err := b.conn.Query(ctx, "get_amrs_by_vod_ids", query, params...)
	amrs, err := models.ReadAMRRows(rows, err, b.logger)
	return amrs, err
}
