package vinyldb

import (
	"regexp"
	"testing"
	"time"

	"golang.org/x/net/context"

	"github.com/DATA-DOG/go-sqlmock"
	"github.com/lib/pq"
	. "github.com/smartystreets/goconvey/convey"

	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"
)

func TestGetAMRsByVodIDs(t *testing.T) {
	Convey("GetAMRsByVodIDs", t, func() {
		now := time.Now().Round(time.Second)
		mock, reader := Setup()
		vodIDs := []int64{int64(1234), int64(2345)}

		fakeResult := sqlmock.NewRows(models.AMRFields)
		fakeResult.AddRow(
			1, 1234, "", "", "", "", "", "", "", false, 0, 0, 0, 0, 0, 0, now,
			now, 0, pq.NullTime{Valid: false}, "")
		fakeResult.AddRow(
			1, 2345, "", "", "", "", "", "", "", false, 0, 0, 0, 0, 0, 0, now,
			now, 0, pq.NullTime{Valid: false}, "")

		query := models.FetchAMRQuery() +
			` WHERE vod_id IN ($1, $2) ORDER BY id ASC`
		mock.ExpectQuery(regexp.QuoteMeta(query)).WithArgs(vodIDs[0], vodIDs[1]).WillReturnRows(fakeResult)

		amrs, err := reader.GetAMRsByVodIDs(context.Background(), vodIDs)

		So(mock.ExpectationsWereMet(), ShouldBeNil)
		So(len(amrs), ShouldEqual, 2)
		So(err, ShouldBeNil)
	})
}
