package vinyldb

import (
	"regexp"
	"testing"

	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"

	. "github.com/smartystreets/goconvey/convey"
	"golang.org/x/net/context"
)

func TestGetAMRs(t *testing.T) {
	Convey("Fetching AMR's for VOD", t, func() {
		mock, reader := Setup()

		Convey("Should run the correct query", func() {
			vodID := 234
			query := regexp.QuoteMeta(models.FetchAMRQuery() + ` WHERE vod_id = $1`)
			mock.ExpectQuery(query).WithArgs(vodID)
			_, err := reader.GetAMRs(context.Background(), vodID)
			So(mock.ExpectationsWereMet(), ShouldBeNil)
			So(err, ShouldNotBeNil)
		})
	})
}
