package vinyldb

import (
	"time"

	"code.justin.tv/chat/db"
	"code.justin.tv/vod/vinyl/datastore/vinyldb/utils"
	"golang.org/x/net/context"
)

// GetIntervalVodIDsToDelete queries for vods that should be deleted within the time interval
func (b *Backend) GetIntervalVodIDsToDelete(ctx context.Context, startTime time.Time, endTime time.Time) ([]int64, error) {
	var vodIDs []int64
	cutoffDays := []int{14, 60, 180}
	for _, days := range cutoffDays {
		relativeStartTime := startTime.AddDate(0, 0, -days)
		relativeEndTime := endTime.AddDate(0, 0, -days)

		var queryParts []interface{}
		queryParts = append(queryParts,
			"SELECT vods.id",
			"FROM vods",
			"LEFT JOIN user_vod_properties ON vods.owner_id = user_vod_properties.user_id",
			"LEFT JOIN vod_appeals ON vods.id = vod_appeals.vod_id",
			"WHERE (vods.broadcast_type = 'archive')",
			"AND ((user_vod_properties.vod_storage_days = ", db.Param, ")")
		if days == 14 {
			queryParts = append(queryParts, " OR (user_vod_properties.vod_storage_days IS NULL)")
		}
		queryParts = append(queryParts, ")",
			"AND (user_vod_properties.save_vods_forever IS NOT TRUE)",
			"AND (vods.started_on > ", db.Param, ")",
			"AND (vods.started_on <= ", db.Param, ")",
			"AND (vods.delete_at IS NULL)",
			"AND (vod_appeals.vod_id IS NULL)")
		query := db.BuildQuery(queryParts...)

		vodIDRows, err := b.conn.Query(ctx, "get_interval_deletion_vods", query, days, relativeStartTime, relativeEndTime)
		if err != nil {
			return []int64{}, err
		}
		defer utils.CloseRows(vodIDRows, b.logger)

		i := 0
		for vodIDRows.Next() {
			var id int64
			if err := vodIDRows.Scan(&id); err != nil {
				return []int64{}, err
			}
			vodIDs = append(vodIDs, id)
			i++
		}
	}

	query := db.BuildQuery(
		"SELECT vods.id",
		"FROM vods",
		"LEFT JOIN user_vod_properties ON vods.owner_id = user_vod_properties.user_id",
		"LEFT JOIN vod_appeals ON vods.id = vod_appeals.vod_id",
		"WHERE (vods.broadcast_type = 'archive')",
		"AND (vods.delete_at > ", db.Param, ")",
		"AND (vods.delete_at <= ", db.Param, ")",
		"AND (vod_appeals.vod_id IS NULL)",
	)
	vodIDRows, err := b.conn.Query(ctx, "get_interval_deletion_vods", query, startTime, endTime)
	if err != nil {
		return []int64{}, err
	}
	defer utils.CloseRows(vodIDRows, b.logger)

	for vodIDRows.Next() {
		var id int64
		if err := vodIDRows.Scan(&id); err != nil {
			return []int64{}, err
		}
		vodIDs = append(vodIDs, id)
	}

	return vodIDs, nil
}
