package vinyldb

import (
	"regexp"
	"testing"
	"time"

	"github.com/DATA-DOG/go-sqlmock"
	. "github.com/smartystreets/goconvey/convey"
	"golang.org/x/net/context"
)

func TestDeleteVodsInterval(t *testing.T) {
	Convey("DeleteVodsInterval", t, func() {
		mock, backend := Setup()

		Convey("Creates the correct 14, 60, 180 day queries and delete_at query for archived vods", func() {
			startTime := time.Now().UTC()
			endTime := time.Now().UTC().AddDate(0, 0, 1)
			for _, days := range []int{14, 60, 180} {
				relativeStartTime := startTime.AddDate(0, 0, -days)
				relativeEndTime := endTime.AddDate(0, 0, -days)

				var storageNullClause string
				if days == 14 {
					storageNullClause = " OR (user_vod_properties.vod_storage_days IS NULL)"
				}

				query := regexp.QuoteMeta(
					`SELECT vods.id ` +
						`FROM vods ` +
						`LEFT JOIN user_vod_properties ON vods.owner_id = user_vod_properties.user_id ` +
						`LEFT JOIN vod_appeals ON vods.id = vod_appeals.vod_id ` +
						`WHERE (vods.broadcast_type = 'archive') ` +
						`AND ((user_vod_properties.vod_storage_days = $1 )` + storageNullClause + ` ) ` +
						`AND (user_vod_properties.save_vods_forever IS NOT TRUE) ` +
						`AND (vods.started_on > $2 ) ` +
						`AND (vods.started_on <= $3 ) ` +
						`AND (vods.delete_at IS NULL) ` +
						`AND (vod_appeals.vod_id IS NULL)`,
				)
				mock.ExpectQuery(query).WithArgs(days, relativeStartTime, relativeEndTime).WillReturnRows(sqlmock.NewRows([]string{}))
			}

			query := regexp.QuoteMeta(
				`SELECT vods.id ` +
					`FROM vods ` +
					`LEFT JOIN user_vod_properties ON vods.owner_id = user_vod_properties.user_id ` +
					`LEFT JOIN vod_appeals ON vods.id = vod_appeals.vod_id ` +
					`WHERE (vods.broadcast_type = 'archive') ` +
					`AND (vods.delete_at > $1 ) ` +
					`AND (vods.delete_at <= $2 ) ` +
					`AND (vod_appeals.vod_id IS NULL)`,
			)
			mock.ExpectQuery(query).WithArgs(startTime, endTime).WillReturnRows(sqlmock.NewRows([]string{}))

			_, err := backend.GetIntervalVodIDsToDelete(context.Background(), startTime, endTime)
			So(mock.ExpectationsWereMet(), ShouldBeNil)
			So(err, ShouldBeNil)
		})
	})
}
