package vinyldb

import (
	"regexp"
	"testing"

	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"

	. "github.com/smartystreets/goconvey/convey"
	"golang.org/x/net/context"
)

//should probably just mock out readvodrows
func TestRelatedVods(t *testing.T) {
	var userID, vodID int
	Convey("Get related vods", t, func() {
		mock, reader := Setup()
		userID = 123
		vodID = 456
		Convey("with same broadcast id", func() {
			query := regexp.QuoteMeta(models.FetchAllVODFieldsQuery() + ` WHERE broadcast_id = (SELECT broadcast_id FROM vods WHERE id = $1 )` +
				` AND id != $2 ` +
				models.Watchable() +
				` ORDER BY created_at DESC LIMIT 5`)
			mock.ExpectQuery(query).WithArgs(vodID, vodID)

			_, err := reader.withSameBroadcastID(context.Background(), vodID)
			So(mock.ExpectationsWereMet(), ShouldBeNil)
			So(err, ShouldNotBeNil)
		})

		Convey("from same owner", func() {
			query := regexp.QuoteMeta(models.FetchAllVODFieldsQuery() + ` WHERE owner_id = $1 ` +
				`AND broadcast_id != (SELECT broadcast_id FROM vods WHERE id = $2 ) ` +
				models.Watchable() +
				` ORDER BY created_at DESC LIMIT 10`)
			mock.ExpectQuery(query).WithArgs(userID, vodID)

			_, err := reader.fromSameOwner(context.Background(), userID, vodID)
			So(mock.ExpectationsWereMet(), ShouldBeNil)
			So(err, ShouldNotBeNil)
			Convey("vodID is 0", func() {
				vodID = 0
				query := regexp.QuoteMeta(models.FetchAllVODFieldsQuery() + ` WHERE owner_id = $1 ` +
					models.Watchable() +
					` ORDER BY created_at DESC LIMIT 10`)
				mock.ExpectQuery(query).WithArgs(userID)

				_, err := reader.fromSameOwner(context.Background(), userID, vodID)
				So(mock.ExpectationsWereMet(), ShouldBeNil)
				So(err, ShouldNotBeNil)
			})
		})
	})
}
